% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_timestamp}
\alias{read_timestamp}
\title{Read Timestamp associated with an object in a workspace.}
\usage{
read_timestamp(x, name, type, subdir = NULL)
}
\arguments{
\item{x}{the workspace}

\item{name}{name of the object stored in the workspace}

\item{type}{content type}

\item{subdir}{Optional subdirectory used for the asset to retrieve}
}
\value{
A character string corresponding to the timestamp (date last modified)
of the stored object.
}
\description{
Read a timestamp associated with an object in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)
read_timestamp(z, name = "obj", type = "rds", subdir = "r-object")
}
\seealso{
\link{workspace} for package documentation

Other functions to read in a workspace: 
\code{\link{list_object_in_workspace}()},
\code{\link{read_dataset_in_workspace}()},
\code{\link{read_json_str_in_workspace}()},
\code{\link{read_raster_in_workspace}()},
\code{\link{read_rds_in_workspace}()},
\code{\link{read_yaml_in_workspace}()}
}
\concept{functions to read in a workspace}
