% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis_distance.R
\name{wbt_cost_distance}
\alias{wbt_cost_distance}
\title{Cost distance}
\usage{
wbt_cost_distance(
  source,
  cost,
  out_accum,
  out_backlink,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{source}{Input source raster file.}

\item{cost}{Input cost (friction) raster file.}

\item{out_accum}{Output cost accumulation raster file.}

\item{out_backlink}{Output backlink raster file.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs cost-distance accumulation on a cost surface and a group of source cells.
}
\keyword{GISAnalysisDistanceTools}
