% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grVizToImageFile.R
\name{grVizToImageFile}
\alias{grVizToImageFile}
\title{Export an htmlwidget object into an image file}
\usage{
grVizToImageFile(g, width = NULL, height = NULL, format = "png",
  folder = ".", filename)
}
\arguments{
\item{g}{an object produced by the \code{grViz} function from the DiagrammmeR package}

\item{width}{the width in pixels of the bitmap}

\item{height}{the height in pixels of the bitmap}

\item{format}{Graphics file format. Currently "png" and "pdf" are supported.}

\item{folder}{path to folder where the PNG file should stored}

\item{filename}{an optional filename stem.
If not provided, the filename stem will be derived from the name 
of the argument of \code{g}.}
}
\value{
Returns the full path of the imagefile.
}
\description{
Export an \code{htmlwidget} object (produced by \code{DiagrammerR::grViz}) into a PNG file
}
\details{
First the \code{grViz} object is exported to an SVG file (using \code{DiagrammeRsvg::export_svg}).
  Then the SVG file is converted to a bitmap (using \code{rsvg::rsvg}).
  Then the bitmap is exported as a PNG file (using \code{png::writePNG}).
  Note that the SVG file and the PNG file will be named using the name of the \code{g} parameter
}
\note{
In addition to the DiagrammmeR package, the following packages are used: \code{DiagrammeRsvg}, \code{rsvg}
}
\author{
Nick Barrowman
}
