% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-utils-rnn.R
\name{nn_utils_rnn_pad_packed_sequence}
\alias{nn_utils_rnn_pad_packed_sequence}
\title{Pads a packed batch of variable length sequences.}
\usage{
nn_utils_rnn_pad_packed_sequence(
  sequence,
  batch_first = FALSE,
  padding_value = 0,
  total_length = NULL
)
}
\arguments{
\item{sequence}{(PackedSequence): batch to pad}

\item{batch_first}{(bool, optional): if \code{True}, the output will be in ``B x T x *`
format.}

\item{padding_value}{(float, optional): values for padded elements.}

\item{total_length}{(int, optional): if not \code{NULL}, the output will be padded to
have length \code{total_length}. This method will throw \code{ValueError}
if \code{total_length} is less than the max sequence length in
\code{sequence}.}
}
\value{
Tuple of Tensor containing the padded sequence, and a Tensor
containing the list of lengths of each sequence in the batch.
Batch elements will be re-ordered as they were ordered originally when
the batch was passed to \code{\link[=nn_utils_rnn_pack_padded_sequence]{nn_utils_rnn_pack_padded_sequence()}} or
\code{\link[=nn_utils_rnn_pack_sequence]{nn_utils_rnn_pack_sequence()}}.
}
\description{
It is an inverse operation to \code{\link[=nn_utils_rnn_pack_padded_sequence]{nn_utils_rnn_pack_padded_sequence()}}.
}
\details{
The returned Tensor's data will be of size \verb{T x B x *}, where \code{T} is the length
of the longest sequence and \code{B} is the batch size. If \code{batch_first} is \code{TRUE},
the data will be transposed into \verb{B x T x *} format.
}
\note{
\code{total_length} is useful to implement the
\verb{pack sequence -> recurrent network -> unpack sequence} pattern in a
\code{nn_module} wrapped in \code{~torch.nn.DataParallel}.
}
\examples{
if (torch_is_installed()) {
seq <- torch_tensor(rbind(c(1, 2, 0), c(3, 0, 0), c(4, 5, 6)))
lens <- c(2, 1, 3)
packed <- nn_utils_rnn_pack_padded_sequence(seq, lens,
  batch_first = TRUE,
  enforce_sorted = FALSE
)
packed
nn_utils_rnn_pad_packed_sequence(packed, batch_first = TRUE)
}
}
