% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseMatrix.R
\name{fromSparseMatrix}
\alias{fromSparseMatrix}
\alias{toSparseMatrix}
\title{Create (or return) a TileDB sparse array}
\usage{
fromSparseMatrix(
  obj,
  uri,
  cell_order = "ROW_MAJOR",
  tile_order = "ROW_MAJOR",
  filter = "ZSTD",
  capacity = 10000L
)

toSparseMatrix(uri)
}
\arguments{
\item{obj}{A sparse matrix object.}

\item{uri}{A character variable with an Array URI.}

\item{cell_order}{A character variable with one of the TileDB cell order values,
default is \dQuote{COL_MAJOR}.}

\item{tile_order}{A character variable with one of the TileDB tile order values,
default is \dQuote{COL_MAJOR}.}

\item{filter}{A character variable vector, defaults to \sQuote{ZSTD}, for
one or more filters to be applied to each attribute;}

\item{capacity}{A integer value with the schema capacity, default is 10000.}
}
\value{
Null, invisibly.
}
\description{
The functions \code{fromSparseMatrix} and \code{toSparseMatrix} help in storing
(and retrieving) sparse matrices using a TileDB backend.
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
\dontrun{
if (requireNamespace("Matrix", quietly=TRUE)) {
  library(Matrix)
  set.seed(123)      # just to fix it
  mat <- matrix(0, nrow=20, ncol=10)
  mat[sample(seq_len(200), 20)] <- seq(1, 20)
  spmat <- as(mat, "dgTMatrix")  # sparse matrix in dgTMatrix format
  uri <- "sparse_matrix"
  fromSparseMatrix(spmat, uri)   # now written
  chk <- toSparseMatrix(uri)     # and re-read
  print(chk)
  all.equal(spmat, chk)
}
}
}
