% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen-examples.R
\name{style_roxygen_example_snippet}
\alias{style_roxygen_example_snippet}
\title{Given a code snippet is dont* or run, style it}
\usage{
style_roxygen_example_snippet(
  code_snippet,
  transformers,
  is_dont,
  base_indention
)
}
\arguments{
\item{code_snippet}{A character vector with code to style.}

\item{transformers}{Passed to \code{\link[=cache_make_key]{cache_make_key()}} to generate a key.}

\item{is_dont}{Whether the snippet to process is a dontrun, dontshow,
donttest segment or not.}

\item{base_indention}{Integer scalar indicating by how many spaces the whole
output text should be indented. Note that this is not the same as splitting
by line and add a \code{base_indention} spaces before the code in the case
multi-line strings are present. See 'Examples'.}
}
\description{
Given a code snippet is dont* or run, style it
}
\section{Hierarchy}{

Styling involves splitting roxygen example code into segments, and segments
into snippets. This describes the process for input of
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}:
\itemize{
\item Splitting code into roxygen example code and other code. Downstream,
we are only concerned about roxygen code. See
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}.
\item Every roxygen example code can have zero or more
dontrun / dontshow / donttest sequences. We next create segments of roxygen
code examples that contain at most one of these. See
\code{\link[=style_roxygen_code_example]{style_roxygen_code_example()}}.
\item We further split the segment that contains at most one dont* sequence into
snippets that are either don* or not. See
\code{\link[=style_roxygen_code_example_segment]{style_roxygen_code_example_segment()}}.
}

Finally, that we have roxygen code snippets that are either dont* or not,
we style them in \code{\link[=style_roxygen_example_snippet]{style_roxygen_example_snippet()}} using
\code{\link[=parse_transform_serialize_r]{parse_transform_serialize_r()}}.
}

\keyword{internal}
