% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadForestContainerCombinedJsonString}
\alias{loadForestContainerCombinedJsonString}
\title{Combine multiple JSON strings representing model objects containing forests (with the same hierarchy / schema) into a single forest_container}
\usage{
loadForestContainerCombinedJsonString(json_string_list, json_forest_label)
}
\arguments{
\item{json_string_list}{List of strings that parse into objects of type \code{CppJson}}

\item{json_forest_label}{Label referring to a particular forest (i.e. "forest_0") in the overall json hierarchy (must exist in every json object in the list)}
}
\value{
\code{ForestSamples} object
}
\description{
Combine multiple JSON strings representing model objects containing forests (with the same hierarchy / schema) into a single forest_container
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
bart_model <- bart(X, y, num_gfr=0, num_mcmc=10)
bart_json_string <- list(saveBARTModelToJsonString(bart_model))
mean_forest <- loadForestContainerCombinedJsonString(bart_json_string, "forest_0")
}
