#' @importFrom tibble tibble
NULL

#' Fake Data for a Time-Series
#'
#' This is a toy (i.e. "fake") data set created by the \code{fabricatr} package.
#'  There are 100 observations. The outcome \code{y} is a linear function
#'  of \code{20 + (.25 * year) + .(25 * x1) + (1 * x2) + e}. This clearly implies
#'  some autocorrelation in the data. I.e. it's a time-series.
#'
#' @format A data frame with 100 observations on the following 5 variables.
#' \describe{
#' \item{\code{year}}{the year}
#' \item{\code{y}}{an outcome}
#' \item{\code{x1}}{a continuous variable}
#' \item{\code{x2}}{a binary variable}
#' \item{\code{e}}{randomly generated errors}
#' }
#'
#' @details Errors are random-normal with a mean of 0 and a standard deviation of 1.
#' \code{x1} is generated by a normal distribution with a mean of 5 and a standard
#' deviation of 2. \code{x2} is drawn from a Bernoulli distribution with a
#' probability of .5 of observing a 1.
#'
"fakeTSD"
