% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{.check_scalar}
\alias{.check_scalar}
\title{Check if an object is a scalar}
\usage{
.check_scalar(
  x,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The object to check.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\value{
\code{NULL}, invisibly, if \code{x} passes the check.
}
\description{
Checks if an object is a scalar, allowing for \code{NULL} and zero-length vectors
if specified.
}
\keyword{internal}
