% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RCOV}
\alias{RCOV}
\title{Regularized Covariance Matrix Calculation}
\arguments{
\item{XX}{A numeric matrix containing the observations, where each column represents a different observation.}

\item{vMu}{A numeric vector representing the mean vector to center the columns of \code{XX}.}

\item{rho}{A numeric scalar representing the regularization parameter (between 0 and 1) that balances between the target matrix and the sample covariance.}

\item{mT}{A numeric matrix representing the target covariance matrix for regularization.}

\item{scfac}{A numeric scalar representing a scaling factor applied to the sample covariance matrix.}
}
\value{
A named list containing:
  \item{rho}{The regularization parameter used in the calculation.}
  \item{mT}{The target covariance matrix provided as input.}
  \item{cov}{The sample covariance matrix calculated from the centered observations.}
  \item{rcov}{The regularized covariance matrix, which is a convex combination of the target matrix and scaled sample covariance matrix.}
}
\description{
Computes a regularized covariance matrix using a convex combination of a target matrix and the sample covariance matrix.
}
\details{
The function calculates the sample covariance matrix of the centered data \code{XX} and combines it with the target covariance matrix \code{mT}, scaled by the factor \code{scfac}. The regularization is controlled by the parameter \code{rho}, where \code{rho = 1} results in using only the target matrix, and \code{rho = 0} uses only the sample covariance.
}
\keyword{internal}
