% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.curves.plot.R
\name{spectral.curves.plot}
\alias{spectral.curves.plot}
\title{Make spectral reflectance curves for defined classes of surface}
\usage{
spectral.curves.plot(data, target_classes = NULL)
}
\arguments{
\item{data}{reflectance data as dataframe with pixel values for Sentinel optical bands
B2, B3, B4, B5, B6, B7, B8, B8A, B11, B12}

\item{target_classes}{list of the classes of surface which should be highlighted, others
will be turned in gray, as a background. Defaults is NULL.}
}
\value{
ggplot2 object with basic visual aesthetics, represents smoother lines with confidence
intervals for each surface class. Default aesthetic is smoother curve (geom_smooth).
May be time-consuming depending on input dataframe size.
See https://ggplot2.tidyverse.org/reference/geom_smooth.html for more details.
}
\description{
Make spectral reflectance curves for defined classes of surface
}
\examples{
# Load example data
load(system.file("testdata/reflectance_test_data.RData", package = "spectralR"))

# Create a plot
p <- spectral.curves.plot(data = reflectance)

# Customize a plot
p +
  ggplot2::labs(x = 'Wavelength, nm', y = 'Reflectance',
      colour = "Surface classes",
      fill = "Surface classes",
      title = "Spectral reflectance curves for different classes of surface",
      caption = 'Data: Sentinel-2 Level-2A')+
  ggplot2::theme_minimal()

# Highlight only specific target classes
spectral.curves.plot(
  data = reflectance,
  target_classes = list("meadow", "coniferous_forest")
  )

}
