% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.distance.R
\name{subsample.distance}
\alias{subsample.distance}
\title{Distance-based subsampling}
\usage{
subsample.distance(x, size, d, d.max = NULL, replacement = FALSE)
}
\arguments{
\item{x}{A POLYGON or POINT sf object}

\item{size}{Subsample size}

\item{d}{Minimum sampling distance in meters}

\item{d.max}{Maximum sampling distance in meters}

\item{replacement}{(FALSE/TRUE) Subsample with replacement}
}
\value{
A subsampled POLYGON or POINT sf object
}
\description{
Draws a minimum, and optional maximum constrained, distance sub-sampling
}
\note{
This function provides a distance constrained subsample of existing point 
      or polygon data. Please note that units are in meters regardless of input
      CRS projection units (including lat/long).
}
\examples{
     
\donttest{
if(require(sp, quietly = TRUE)) {
library(sf)
  data(meuse, package = "sp")
  meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                    agr = "constant")

# Subsample with a 500m minimum sample spread 
sub.meuse <- subsample.distance(meuse, size = 10, d = 500)  
  plot(st_geometry(meuse), pch=19, main="min dist = 500")
    plot(st_geometry(sub.meuse), pch=19, col="red", add=TRUE) 
 
# Check distances	
dm <- st_distance(sub.meuse)
  diag(dm) <- NA
cat("\n", "Min distance for subsample", min(dm, na.rm=TRUE), "\n")  
cat("Max distance for subsample", max(dm, na.rm=TRUE), "\n")  

} else { 
  cat("Please install sp package to run example", "\n")
}
}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
