% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_selection_cv_tnkde_sf.R
\name{bw_checks}
\alias{bw_checks}
\title{Check function for parameters in bandwidth selection methods}
\usage{
bw_checks(
  check,
  lines,
  samples,
  events,
  kernel_name,
  method,
  bws_net = NULL,
  bws_time = NULL,
  arr_bws_net = NULL,
  arr_bws_time = NULL,
  adaptive = FALSE,
  trim_net_bws = NULL,
  trim_time_bws = NULL,
  diggle_correction = FALSE,
  study_area = NULL
)
}
\arguments{
\item{check}{A boolean indicating if the geometries must be checked}

\item{lines}{A feature collection of linestrings representing the underlying network}

\item{samples}{A feature collection of points representing the sample location}

\item{events}{a feature collection of points representing the events}

\item{kernel_name}{The name of the kernel to use}

\item{method}{The name of the NKDE to use}

\item{bws_net}{An ordered numeric vector with all the network bandwidths}

\item{bws_time}{An ordered numeric vector with all the time bandwidths}

\item{arr_bws_net}{An array with all the local netowrk bandwidths precalculated (for each event, and at each possible combinaison of network and temporal bandwidths). The dimensions must be c(length(net_bws), length(time_bws), nrow(events)))}

\item{arr_bws_time}{An array with all the local time bandwidths precalculated (for each event, and at each possible combinaison of network and temporal bandwidths). The dimensions must be c(length(net_bws), length(time_bws), nrow(events)))}

\item{adaptive}{A boolean indicating if local bandwidths must be calculated}

\item{trim_net_bws}{A numeric vector with the maximum local network bandwidth. If local bandwidths have higher values, they will be replaced by the corresponding value in this vector.}

\item{trim_time_bws}{A numeric vector with the maximum local time bandwidth. If local bandwidths have higher values, they will be replaced by the corresponding value in this vector.}

\item{diggle_correction}{A Boolean indicating if the correction factor
for edge effect must be used.}

\item{study_area}{A feature collection of polygons
representing the limits of the study area.}
}
\description{
A check function for bandwidth selection methods raising an error if a parameter is not valid
}
\examples{
# no example provided, this is an internal function
}
\keyword{internal}
