% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smm.R
\name{simulate.smm}
\alias{simulate.smm}
\title{Simulates semi-Markov chains}
\usage{
\method{simulate}{smm}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{An object of S3 class \code{smm} (inheriting from the S3 class
\link{smmnonparametric} or \link{smmparametric}).}

\item{nsim}{An integer or vector of integers (for multiple sequences)
specifying the length of the sequence(s).}

\item{seed}{Optional. \code{seed} for the random number generator.
If no \code{seed} is given, then seed is set by using the command
\verb{set.seed(round(as.numeric(Sys.time()))}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of vectors representing the sequences.
}
\description{
Simulates sequences from a semi-Markov model.
}
\details{
If \code{nsim} is a single integer then a chain of that length is
produced. If \code{nsim} is a vector of integers, then \code{length(nsim)}
sequences are generated with respective lengths.
}
\references{
V. S. Barbu, N. Limnios. (2008). Semi-Markov Chains and Hidden Semi-Markov
Models Toward Applications - Their Use in Reliability and DNA Analysis.
New York: Lecture Notes in Statistics, vol. 191, Springer.
}
\seealso{
\link{smmparametric}, \link{smmnonparametric}, \link{fitsmm}
}
