% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.R
\name{silv_sample_size_simple}
\alias{silv_sample_size_simple}
\title{Calculates sample size for a simple random sampling (SRS)}
\usage{
silv_sample_size_simple(
  x,
  plot_size,
  total_area,
  max_error = 0.05,
  conf_level = 0.95,
  max_iter = 1000,
  quiet = FALSE
)
}
\arguments{
\item{x}{vector of the variable measured in the pilot inventory (e.g. basal area, volume)}

\item{plot_size}{a numeric vector of length one with plot size in squared meters}

\item{total_area}{total area of the study area in squared meters}

\item{max_error}{maximum allowed relative error}

\item{conf_level}{confidence level}

\item{max_iter}{maximum number of iteration to find the plot size}

\item{quiet}{if \code{TRUE}, messages will be supressed}
}
\value{
SimpleSampleSize object
}
\description{
Calculates the sample size needed for a SRS inventory, estimated from
pilot inventory data.
}
\details{
Sample size is very important to be optimized, since a small sample size
will entail a higher error, while a huge sample size will entail higher
costs. The SRS is typically used for random sampling, although it might
be used also for regular sampling. The number of samples is calculated using
the expression:

\eqn{n \ge \frac{t^2 \cdot CV^2}{\epsilon^2 + \frac{t^2 \cdot CV^2}{N}}}

Where:
\itemize{
\item \strong{t}: the value of student's t for given sample size of the pilot inventory
\item \strong{CV}: the coefficient of variation of \code{x}
\item \eqn{\epsilon}: the relative error (\code{max_error})
\item \strong{N}: the size of the pilot inventory
}

\code{x} is a variable measured in a pilot inventory. Let's say we measure forest
variables in 10 pilot plots, aiming at basal area measurement so we have to
measure only the DBH. After some calculations, we will have the basal area
per hectare in each of the 10 plots. The sample size is then calculated from
the variation of these values and the error that we will allow.
}
\examples{
## pilot inventory measuring 4 plots of 25x25 meters
## total forest area 15 ha
## measured variable (x): basal area per hectare
silv_sample_size_simple(
  x          = c(33, 37.5, 42, 35.2),
  plot_size  = 25 * 25,  # squared plot of 25x25
  total_area = 15 * 1e4, # 15 ha
  max_error  = 0.05,
  conf_level = 0.95,
  max_iter   = 100
)
}
