% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-funs.R
\name{silv_diametric_class}
\alias{silv_diametric_class}
\title{Classify diameters in classes}
\usage{
silv_diametric_class(
  diameter,
  dmin = 7.5,
  dmax = NULL,
  class_length = 5,
  include_lowest = TRUE,
  return_intervals = FALSE
)
}
\arguments{
\item{diameter}{A numeric vector of diameters}

\item{dmin}{The minimum inventory diameter in centimeters}

\item{dmax}{The maximum inventory diameter in centimeters. Values that
are greater than \code{dmax} are included in the greatest class}

\item{class_length}{The length of the class in centimeters}

\item{include_lowest}{Logical. If TRUE (the default), the intervals are
\verb{[dim1, dim2)}. If FALSE, the intervals are \verb{(dim1, dim2]}

[dim1, dim2)\verb{. If FALSE, the intervals are }(dim1, dim2]: R:dim1,\%20dim2)\%60.\%20If\%20FALSE,\%20the\%20intervals\%20are\%20\%60(dim1,\%20dim2}

\item{return_intervals}{If FALSE, it returns the intervals. Otherwise (the
default), it returns the class center}
}
\value{
A numeric vector
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Classifies the measured diameters into classes of a specified length
}
\examples{
library(dplyr)
inventory_samples |>
  mutate(dclass = silv_diametric_class(diameter))
}
