% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_functions.R
\name{predict.shrinkGPR}
\alias{predict.shrinkGPR}
\title{Generate Predictions}
\usage{
\method{predict}{shrinkGPR}(object, newdata, nsamp = 100, ...)
}
\arguments{
\item{object}{A \code{shrinkGPR} object representing the fitted Gaussian process regression model.}

\item{newdata}{\emph{Optional} data frame containing the covariates for the prediction points. If missing, the training data is used.}

\item{nsamp}{Positive integer specifying the number of posterior samples to generate. Default is 100.}

\item{...}{Currently ignored.}
}
\value{
A matrix containing posterior predictive samples for each covariate combination in \code{newdata}.
}
\description{
\code{predict.shrinkGPR} generates posterior predictive samples from a fitted \code{shrinkGPR} model at specified covariates.
}
\details{
This function generates predictions by sampling from the posterior predictive distribution. If the mean equation is included in the model, the corresponding covariates are incorporated.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Simulate data
  set.seed(123)
  torch::torch_manual_seed(123)
  n <- 100
  x <- matrix(runif(n * 2), n, 2)
  y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
  data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

  # Fit GPR model
  res <- shrinkGPR(y ~ x1 + x2, data = data)
  # Example usage for in-sample prediction
  preds <- predict(res)

  # Example usage for out-of-sample prediction
  newdata <- data.frame(x1 = runif(10), x2 = runif(10))
  preds <- predict(res, newdata = newdata)
  }
}
}
