% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_multis.R
\name{sfcr_multis}
\alias{sfcr_multis}
\title{Simulate multiple SFC models at the same time}
\usage{
sfcr_multis(expanded, fixed, periods, ...)
}
\arguments{
\item{expanded}{A \code{sfcr_mlt_set}, \code{sfcr_mlt_shock}, or a
\code{sfcr_mlt} object.}

\item{fixed}{A \code{sfcr_set}, \code{sfcr_tbl}, or \code{sfcr_shock} object.}

\item{periods}{A number specifying the total number of periods of the model to be simulated.}

\item{...}{Additional arguments to pass to the underlying implementation of the
\code{sfcr_baseline()} or \code{sfcr_scenario()} functions.}
}
\description{
The \code{sfcr_multis()} function is used to simulate multiple models
at the same time, returning a list of \code{sfcr_tbl}s.
}
\details{
The \code{sfcr_multis()} function takes an \code{expanded} object and
a \code{fixed} to simulate multiple models that will share the content
of \code{fixed} but vary on the \code{expanded}.

This function is a \strong{generic}, which means that its implementation
depends on the class of the \code{expanded} argument.

The available methods for the \code{sfcr_multis()} function depends
on the \code{expanded} argument. There are three possible methods:
\itemize{
\item \code{sfcr_mlt_set}:
When the \code{sfcr_multis()} takes an \code{sfcr_mlt_set} class
as the input of \code{expanded}, it must take a list of equations of
the \code{sfcr_set} class as the \code{fixed} input. This method
simulates many baseline models that accept the same set of equations
and vary on the external variables supplied with the \code{expanded}
argument.
\item \code{sfcr_mlt_shock}:
When the \code{sfcr_multis()} takes an \code{sfcr_mlt_shock} class
as the input of \code{expanded}, it must also take an object of
\code{sfcr_tbl} class as the input of \code{fixed}. It will simulate
multiple scenario models that takes the same baseline model
and diverge on the content of the multiple shocks provided with the
\code{expanded} argument that are applied to it.
\item \code{sfcr_mlt}:
When the \code{sfcr_multis()} function takes a \code{sfcr_mlt} class
object as the input of the \code{expanded} argument, a \code{sfcr_shock}
object must be supplied with the \code{fixed} argument. This method
simulates multiple scenario models that applies the same shock to a
varying number of baseline models.
}
}
\examples{
eqs <- sfcr_set(
  TX_s ~ TX_d,
  YD ~ W * N_s - TX_s,
  C_d ~ alpha1 * YD + alpha2 * H_h[-1],
  H_h ~ YD - C_d + H_h[-1],
  N_s ~ N_d,
  N_d ~ Y / W,
  C_s ~ C_d,
  G_s ~ G_d,
  Y ~ C_s + G_s,
  TX_d ~ theta * W * N_s,
  H_s ~ G_d - TX_d + H_s[-1]
)

external <- sfcr_set(G_d ~ 20, W ~ 1, alpha1 ~ 0.6, alpha2 ~ 0.4, theta ~ 0.2)

shock <- sfcr_shock(
  variables = sfcr_set(
    alpha2 ~ 0.3
  ),
  start = 1,
  end = 3
)

baseline <- sfcr_baseline(eqs, external, periods = 5)

# Example 1: Many external sets, 1 set of equations:
expanded1 <- sfcr_expand(external, alpha1, c(0.7, 0.8))
multis1 <- sfcr_multis(expanded = expanded1, fixed = eqs, periods = 5)

# Example 2: Many shocks, 1 baseline model:
expanded2 <- sfcr_expand(shock, alpha2, c(0.1, 0.2))
multis2 <- sfcr_multis(expanded = expanded2, fixed = baseline, periods = 5)

# Example 3: Many baseline models, 1 shock:
multis3 <- sfcr_multis(expanded = multis1, fixed = shock, periods = 5)

}
\author{
João Macalós
}
