% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_smooth.R
\name{scf_plot_smooth}
\alias{scf_plot_smooth}
\title{Smoothed Distribution Plot of a Continuous Variable in SCF Data}
\usage{
scf_plot_smooth(
  design,
  variable,
  binwidth = NULL,
  xlim = NULL,
  method = "loess",
  span = 0.2,
  color = "blue",
  xlab = NULL,
  ylab = "Percent of Households",
  title = NULL
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}.}

\item{variable}{A one-sided formula specifying a continuous variable (e.g., \code{~networth}).}

\item{binwidth}{Optional bin width. Default uses Freedman–Diaconis rule.}

\item{xlim}{Optional numeric vector of length 2 to truncate axis.}

\item{method}{Character. Smoothing method: \code{"loess"} (default) or \code{"lm"}.}

\item{span}{Numeric LOESS span. Default is \code{0.2}. Ignored if \code{method = "lm"}.}

\item{color}{Line color. Default is \code{"blue"}.}

\item{xlab}{Optional label for x-axis. Defaults to the variable name.}

\item{ylab}{Optional label for y-axis. Defaults to \code{"Percent of Households"}.}

\item{title}{Optional plot title.}
}
\value{
A \code{ggplot2} object.
}
\description{
Draws a smoothed distribution plot of a continuous variable in the SCF. Use
this function to visualize a single continuous variable's distribution.
}
\section{Implementation}{

Visualizes the weighted distribution of a continuous SCF variable by stacking implicates,
binning observations, and smoothing pooled proportions. This function is useful for
examining distribution shape, skew, or modality in variables like income or wealth.

All implicates are stacked and weighted, binned across a data-driven or user-specified
bin width. Each bin's weight share is calculated, and a smoothing curve is fit to
the resulting pseudo-density.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("plot_smooth_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Plot smoothed distribution
scf_plot_smooth(scf2022, ~networth, xlim = c(0, 2e6),
                method = "loess", span = 0.25)
     
# Do not implement these lines in real analysis: Cleanup for package check           
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_theme]{scf_theme()}}, \code{\link[=scf_plot_dist]{scf_plot_dist()}}
}
