% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filename_sanitizer.R
\name{filename_sanitizer}
\alias{filename_sanitizer}
\title{File/folder name sanitizer replacing space and punctuation with underscore}
\usage{
filename_sanitizer(
  x,
  max_chars = NA_integer_,
  accept_hyphen = FALSE,
  sep = "_",
  valid_obj = FALSE,
  to_lower = FALSE,
  make_unique = TRUE
)
}
\arguments{
\item{x}{Character vector of file/folder names}

\item{max_chars}{Maximum character length}

\item{accept_hyphen}{Flag, whether a hyphen - is acceptable.}

\item{sep}{String, replacement for illegal characters and spaces.}

\item{valid_obj}{Flag, whether output should be valid as R object name.}

\item{to_lower}{Flag, whether to force all characters to lower.}

\item{make_unique}{Flag, whether all should be unique.}
}
\value{
Character vector of same length as x
}
\description{
File/folder name sanitizer replacing space and punctuation with underscore
}
\examples{
filename_sanitizer(c("Too long a name", "with invalid *^/&#"))
}
