% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_stoichiometry.r
\name{stoichiometry}
\alias{stoichiometry}
\title{Return the Stoichiometry Matrix}
\arguments{
\item{box}{Either \code{NULL} or a vector of positive integers pointing
to a spatial sub-unit of the model.
If \code{NULL}, the mathematical expressions appearing in the
stoichiometry matrix are not evaluated, hence, they are returned as
character strings. If a spatial sub-unit is specified, a numeric matrix is
returned. In the latter case, the values of state variables and parameters
must have been set using the \code{\link{setVars}} and
\code{\link{setPars}} methods.}

\item{time}{Time. The value is ignored in the case of autonomous models.}
}
\value{
A matrix of numeric or character type, depending on the value of
 \code{box}.
}
\description{
Return and optionally evaluate the mathematical expression appearing in the
stoichiometry matrix.
}
\note{
If the stoichiometric factors are mathematical expressions involving
  function references, these functions must be defined in R (even if the
  numerical computations are based on generated Fortran code).
}
\examples{
data(vars, pars, funs, pros, stoi)
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
model$setPars(c(mu=0.8, half=0.1, yield= 0.1, vol=1000, flow=50, sub_in=1))
model$setVars(c(bac=0.1, sub=0.5))
monod <- function(c,h) {c/(c+h)}
print(model$stoichiometry(box=NULL))
print(model$stoichiometry(box=c(1)))
}
\seealso{
See other methods of the \code{\link{rodeo-class}} or
  \code{\link{plotStoichiometry}} for a graphical representation of the
  stoichiometric factors only.
}
\author{
\email{david.kneis@tu-dresden.de}
}
