% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kroclearn.R
\name{kroclearn}
\alias{kroclearn}
\title{Fit a kernel model}
\usage{
kroclearn(
  X,
  y,
  lambda,
  kernel = "radial",
  param.kernel = NULL,
  loss = "hinge",
  approx = NULL,
  intercept = TRUE,
  target.perf = list(),
  param.convergence = list()
)
}
\arguments{
\item{X}{Predictor matrix or data.frame (categorical variables are
automatically one-hot encoded).}

\item{y}{Response vector with class labels in \{-1, 1\}. Labels given as
\{0, 1\} or as a two-level factor/character are automatically converted
to this format.}

\item{lambda}{Positive scalar regularization parameter.}

\item{kernel}{Kernel type: \code{"radial"} (default), \code{"polynomial"},
\code{"linear"}, or \code{"laplace"}.}

\item{param.kernel}{Kernel-specific parameter:
\itemize{
\item \eqn{\sigma} for \code{"radial"} and \code{"laplace"} kernels
(default \eqn{1/p}, where \eqn{p} is the number of predictors after preprocessing,
i.e., after categorical variables are one-hot encoded).
\item Degree for \code{"polynomial"} kernel (default 2).
\item Ignored for \code{"linear"} kernel.
}}

\item{loss}{Surrogate loss function type. One of:
\code{"hinge"} (default), \code{"hinge2"} (squared hinge),
\code{"logistic"}, or \code{"exponential"}.}

\item{approx}{Logical; enables a scalable approximation to accelerate training.
The default is \code{TRUE} when \code{nrow(X) >= 1000}, and \code{FALSE} otherwise.
For details about how approximation is applied, see the \code{details} section.}

\item{intercept}{Logical; include an intercept in the model (default \code{TRUE}).}

\item{target.perf}{List with target sensitivity and specificity used when
estimating the intercept (defaults to 0.9 each).}

\item{param.convergence}{List of convergence controls (e.g., \code{maxiter},
\code{eps}). Default is \code{list(maxiter = 5e4, eps = 1e-4)}.}
}
\value{
An object of class \code{"kroclearn"}, a list containing:
\itemize{
\item \code{theta.hat} — estimated dual coefficient vector.
\item \code{intercept} — fitted intercept (if applicable).
\item \code{lambda}, \code{kernel}, \code{param.kernel}, \code{loss}.
\item \code{approx}, \code{B} (number of sampled pairs if approximation used).
\item \code{time} — training time (seconds).
\item \code{nobs}, \code{p} — number of observations and predictors.
\item \code{converged}, \code{n.iter} — convergence information.
\item \code{kfunc} — kernel function object.
\item \code{nystrom} — low rank kernel approximation details (if used).
\item \code{X} — training data (post-preprocessing).
\item \code{preprocessing} — details on categorical variables,
removed columns, and column names.
\item \code{call} — the function call.
}
}
\description{
Fit a kernel model
}
\details{
For large-scale data, the model is computationally prohibitive because its
loss is a U-statistic involving a double summation. To reduce this burden,
the package adopts an efficient algorithm based on an incomplete U-statistic,
which approximates the loss with a single summation. In kernel models,
a Nyström low-rank approximation is further applied to efficiently compute
the kernel matrix. These approximations substantially reduce computational
cost and accelerate training, while maintaining accuracy, making the model
feasible for large-scale datasets. This option is available when
\code{@param approx = TRUE}.
}
\examples{
set.seed(123)
n <- 100
r <- sqrt(runif(n, 0.05, 1))
theta <- runif(n, 0, 2*pi)
X <- cbind(r * cos(theta), r * sin(theta))
y <- ifelse(r < 0.5, 1, -1)

fit <- kroclearn(X, y, lambda = 0.1, kernel = "radial", approx=TRUE)
}
