% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{check_org_unit}
\alias{check_org_unit}
\title{Validate user-specified organisation unit ID or name.}
\usage{
check_org_unit(login, org_unit, org_units = NULL)
}
\arguments{
\item{login}{A httr2 request object preconfigured for authentication
carrying the base url, user name, and password.}

\item{org_unit}{A character denoting the name or id of the organisation unit}

\item{org_units}{An optional data frame of organisation units as returned by
the \code{get_organisation_units()} function.}
}
\value{
The organisation unit ID if the provided organisation unit ID or
name exists; otherwise, an error is thrown with a suggestion to use the
function that lists all available organisation units from the target DHIS2
instance.
}
\description{
Check whether a given organisation unit identifier or name is valid
within a DHIS2 instance. If a valid name is provided, the corresponding
organisation unit ID is returned. Otherwise, an informative error message is
thrown.
}
\keyword{internal}
