% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\docType{package}
\name{rdav}
\alias{rdav-package}
\alias{rdav}
\title{rdav: Interchange Files With 'WebDAV' Servers}
\description{
Provides functions to interchange files with WebDAV servers
}
\details{
\itemize{
\item download a file or a directory (recursively) from a WebDAV server
\item upload a file or a directory (recursively) to a WebDAV server
\item copy, move, delete files or directories on a WebDAV server
\item list directories on the WebDAV server
}

Notice: when uploading or downloading files, they are overwritten without any
warnings.
}
\examples{
\dontrun{
# establish a connection, you will be asked for a password
r <- wd_connect("https://example.com/remote.php/webdav/","exampleuser")

# show files / directoriess in main directory
wd_dir(r)

# lists 'subdir', returns a dataframe
wd_dir(r, "subdir", as_df = TRUE)

# create directory 'mydirectory' on the server
wd_mkdir(r,"mydirectory")

# upload the local file testfile.R to the subdirectory 'mydirectory'
wd_upload(r, "testfile.R", "mydirectory/testfile.R")

# download content of 'mydirectory' from the server and
# store it in 'd:/data/fromserver' on your computer
wd_download(r, "mydirectory", "d:/data/fromserver")

}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/gk-crop/rdav}
  \item Report bugs at \url{https://github.com/gk-crop/rdav/issues}
}

}
\author{
{Gunther Krauss}
}
