% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{rowSums_if}
\alias{rowSums_if}
\title{Row Sums Conditional on Frequency of Observed Values}
\usage{
rowSums_if(
  x,
  ov.min = 1,
  prop = TRUE,
  inclusive = TRUE,
  impute = TRUE,
  allNA = NA_real_
)
}
\arguments{
\item{x}{numeric or logical matrix. If not a matrix, it will be coerced to
one.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{ncol(x)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the sum should
be calculated if the frequency of observed values in a row is exactly equal
to \code{ov.min}.}

\item{impute}{logical vector of length 1 specifying if missing values should
be imputed with the mean of observed values of \code{x[i, ]}. If TRUE
(default), this will make sums over the same columns with different amounts
of observed data comparable.}

\item{allNA}{numeric vector of length 1 specifying what value should be
returned for rows that are all NA. This is most applicable when
\code{ov.min = 0} and \code{inclusive = TRUE}. The default is NA, which
differs from \code{rowSums} with \code{na.rm = TRUE} where 0 is returned.
Note, the value is overwritten by NA if the frequency of observed values in
that row is less than (or equal to) that specified by \code{ov.min}.}
}
\value{
numeric vector of length = \code{nrow(x)} with names =
  \code{rownames(x)} providing the sum of each row or NA (or \code{allNA})
  depending on the frequency of observed values.
}
\description{
\code{rowSums_if} calculates the sum of every row in a numeric or logical
matrix conditional on the frequency of observed data. If the frequency of
observed values in that row is less than (or equal to) that specified by
\code{ov.min}, then NA is returned for that row. It also has the option to
return a value other than 0 (e.g., NA) when all rows are NA, which differs
from \code{rowSums(x, na.rm = TRUE)}.
}
\details{
Conceptually this function is doing: \code{apply(X = x, MARGIN = 1, FUN =
sum_if, ov.min = ov.min, prop = prop, inclusive = inclusive)}. But for
computational efficiency purposes it does not because then the observed
values conditioning would not be vectorized. Instead, it uses \code{rowSums}
and then inserts NAs for rows that have too few observed values.
}
\examples{
rowSums_if(airquality)
rowSums_if(x = airquality, ov.min = 5, prop = FALSE)
x <- data.frame("x" = c(1, 1, NA), "y" = c(2, NA, NA), "z" = c(NA, NA, NA))
rowSums_if(x)
rowSums_if(x, ov.min = 0)
rowSums_if(x, ov.min = 0, allNA = 0)
identical(x = rowSums(x, na.rm = TRUE),
   y = unname(rowSums_if(x, impute = FALSE, ov.min = 0, allNA = 0))) # identical to
   # rowSums(x, na.rm = TRUE)
}
\seealso{
\code{\link{rowMeans_if}}
   \code{\link{colSums_if}}
   \code{\link{colMeans_if}}
   \code{\link{rowSums}}
}
