% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{icc_all_by}
\alias{icc_all_by}
\title{All Six Intraclass Correlations by Group}
\usage{
icc_all_by(data, vrb.nm, grp.nm, ci.level = 0.95, check = TRUE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
groups.}

\item{ci.level}{double vector of length 1 specifying the confidence level. It
must range from 0 to 1.}

\item{check}{logical vector of length 1 specifying whether to check the
structure of the input arguments. For example, check whether
\code{data[vrb.nm]} are all typeof numeric. This argument is available to
allow flexibility in whether the user values informative error messages
(TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame containing the unique combinations of the grouping variables
\code{data[grp.nm]} and each group's intraclass correlations (ICCs), their confidence intervals,
information about the \code{merMod} object from the linear mixed effects model,
and any warning or error messages from \code{\link[lme4]{lmer}}. For an understanding of the
six different ICCs, see the following blogpost:
\url{http://www.daviddisabato.com/blog/2021/10/1/the-six-different-types-of-intraclass-correlations-iccs}.
The first columns are always \code{unique.data.frame(data[vrb.nm])}. All other columns are in the
following order with the following colnames:

\describe{
   \item{icc11_est}{ICC(1,1) parameter estimate}
   \item{icc11_lwr}{ICC(1,1) lower bound of the confidence interval}
   \item{icc11_upr}{ICC(1,1) lower bound of the confidence interval}
   \item{icc21_est}{ICC(2,1) parameter estimate}
   \item{icc21_lwr}{ICC(2,1) lower bound of the confidence interval}
   \item{icc21_upr}{ICC(2,1) lower bound of the confidence interval}
   \item{icc31_est}{ICC(3,1) parameter estimate}
   \item{icc31_lwr}{ICC(3,1) lower bound of the confidence interval}
   \item{icc31_upr}{ICC(3,1) lower bound of the confidence interval}
   \item{icc1k_est}{ICC(1,k) parameter estimate}
   \item{icc1k_lwr}{ICC(1,k) lower bound of the confidence interval}
   \item{icc1k_upr}{ICC(1,k) lower bound of the confidence interval}
   \item{icc2k_est}{ICC(2,k) parameter estimate}
   \item{icc2k_lwr}{ICC(2,k) lower bound of the confidence interval}
   \item{icc2k_upr}{ICC(2,k) lower bound of the confidence interval}
   \item{icc3k_est}{ICC(3,k) parameter estimate}
   \item{icc3k_lwr}{ICC(3,k) lower bound of the confidence interval}
   \item{icc3k_upr}{ICC(3,k) lower bound of the confidence interval}
   \item{lmer_nobs}{number of observations used for the linear mixed effects model.
   Note, this is the number of (non-missing) rows after \code{data[vrb.nm]}
   has been stacked together via \code{\link[utils]{stack}}.}
   \item{lmer_ngrps}{number of groups used for the linear mixed effects model.
   This is the number of unique combinations of the grouping variables after \code{data[grp.nm]}.}
   \item{lmer_logLik}{logLik of the linear mixed effects model}
   \item{lmer_sing}{binary variable where 1 = the linear mixed effects model had
   a singularity in the random effects covariance matrix or 0 = it did not}
   \item{lmer_warn}{binary variable where 1 = the linear mixed effects model
   returned a warning or 0 = it did not}
   \item{lmer_err}{binary variable where 1 = the linear mixed effects model
   returned an error or 0 = it did not}
   \item{warn_mssg}{character vector providing the warning messages for any warnings.
   If a group did not generate a warning, then the value is NA}
   \item{err_mssg}{character vector providing the error messages for any warnings.
   If a group did not generate an error, then the value is NA}
}
}
\description{
\code{icc_all_by} computes each of the six intraclass correlations (ICC) in
Shrout & Fleiss (1979) by group. The ICCs differ by whether they treat
dimensions as fixed or random and whether they are for a single variable in
\code{data[vrb.nm]} of the set of variables \code{data[vrb.nm]}.
\code{icc_all_by} also returns information about the linear mixed effects
modeling (using \code{\link[lme4]{lmer}}) used to compute the ICCs as well as
any warning or error messages by group. For an understanding of the six
different ICCs, see the following blogpost:
\url{http://www.daviddisabato.com/blog/2021/10/1/the-six-different-types-of-intraclass-correlations-iccs}.
\code{icc_all_by} is a combination of \code{\link{by2}} +
\code{\link[str2str]{try_fun}} + \code{\link[psych]{ICC}}
(\code{\link[psych]{ICC}} calls \code{\link[lme4]{lmer}} internally).
}
\details{
\code{icc_all_by} internally suppresses any messages, warnings, or errors
returned by \code{\link[lme4]{lmer}} (e.g., "boundary (singular) fit: see
?isSingular") because that information is provided in the returned
data.frame.
}
\examples{

# one grouping variable
x <- icc_all_by(data = psych::bfi, vrb.nm = c("A2","A3","A4","A5"),
   grp.nm = "gender")

# two grouping variables
y <- icc_all_by(data = psych::bfi, vrb.nm = c("A2","A3","A4","A5"),
   grp.nm = c("gender","education"))

# with errors
z <- icc_all_by(data = psych::bfi, vrb.nm = c("A2","A3","A4","A5"),
   grp.nm = c("age")) # NA for all ICC columns when there is an error

}
\references{
Shrout, P.E., & Fleiss, J.L. (1979). Intraclass correlations: Uses in assessing rater reliability.
   Psychological Bulletin, 86(2), 420-428.
}
\seealso{
\code{\link[psych]{ICC}}
   \code{\link[lme4]{lmer}}
}
