% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{dum2nom}
\alias{dum2nom}
\title{Dummy Variables to a Nominal Variable}
\usage{
dum2nom(data, dum.nm, yes = 1L, rtn.fct = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{dum.nm}{character vector of colnames from \code{data} specifying the
dummy variables.}

\item{yes}{atomic vector of length 1 specifying the unique value of the
category in each dummy column. This must be the same value for all the
dummy variables.}

\item{rtn.fct}{logical vector of length 1 specifying whether the return
object should be a factor (TRUE) or a character vector (FALSE).}
}
\value{
character vector (or factor if \code{rtn.fct} = TRUE) containing the
  unique values of \code{dum.nm} - one for each dummy variable.
}
\description{
\code{dum2nom} converts dummy variables to a nominal variable. The
information from the dummy columns in a data.frame are combined into a
character vector (or factor if \code{rtn.fct} = TRUE) representing a nominal
variable. The unique values of the nominal variable will be the dummy
colnames (i.e., \code{dum.nm}). Note, *all* the dummy variables associated
with a nominal variable are required for this function to work properly. In
regression-like models, data analysts will exclude one dummy variable for the
category that is the reference group. If d = number of categories in the
nominal variable, then that leads to d - 1 dummy variables in the model.
\code{dum2nom} requires all d dummy variables.
}
\details{
\code{dum2nom} tests to ensure that \code{data[dum.nm]} are indeed a set of
dummy columns. First, the dummy columns are expected to have the same mode
such that there is one \code{yes} unique value across the dummy columns.
Second, each row in \code{data[dum.nm]} is expected to have either 0 or 1
instance of \code{yes}. If there is more than one instance of \code{yes} in a
row, then an error is returned. If there is 0 instances of \code{yes} in a
row (e.g., all missing values), NA is returned for that row. Note, any value
other than \code{yes} will be treated as a no.
}
\examples{
dum <- data.frame(
   "Quebec_nonchilled" = ifelse(CO2$"Type" == "Quebec" & CO2$"Treatment" == "nonchilled",
      yes = 1L, no = 0L),
   "Quebec_chilled" = ifelse(CO2$"Type" == "Quebec" & CO2$"Treatment" == "chilled",
      yes = 1L, no = 0L),
   "Mississippi_nonchilled" = ifelse(CO2$"Type" == "Mississippi" & CO2$"Treatment" == "nonchilled",
      yes = 1L, no = 0L),
   "Mississippi_chilled" = ifelse(CO2$"Type" == "Mississippi" & CO2$"Treatment" == "chilled",
      yes = 1L, no = 0L)
)
dum2nom(data = dum, dum.nm = names(dum)) # default
dum2nom(data = dum, dum.nm = names(dum), rtn.fct = TRUE) # return as a factor
\dontrun{
dum2nom(data = npk, dum.nm = c("N","P","K")) # error due to overlapping dummy columns
dum2nom(data = mtcars, dum.nm = c("vs","am"))# error due to overlapping dummy columns
}
}
\seealso{
\code{\link{nom2dum}}
}
