% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{cor_ml}
\alias{cor_ml}
\title{Multilevel Correlation Matrices}
\usage{
cor_ml(data, vrb.nm, grp.nm, use = "pairwise.complete.obs", method = "pearson")
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{grp.nm}{character vector of length 1 of a colname from \code{data}
specifying the grouping column.}

\item{use}{character vector of length 1 specifying how to handle missing
values when computing the correlations. The options are: 1.
"pairwise.complete.obs" which uses pairwise deletion, 2. "complete.obs"
which uses listwise deletion, and 3. "everything" which uses all cases and
returns NA for any correlations from columns in \code{data[vrb.nm]} with
missing values.}

\item{method}{character vector of length 1 specifying which type of
correlations to compute. The options are: 1. "pearson" for traditional
Pearson product-moment correlations, 2. "kendall" for Kendall rank
correlations, and 3. "spearman" for Spearman rank correlations.}
}
\value{
list with two elements named "within" and "between" each containing a
  numeric matrix. The first "within" matrix is the within-group correlation
  matrix and the second "between" matrix is the between-group correlation
  matrix. The rownames and colnames of each numeric matrix are \code{vrb.nm}.
}
\description{
\code{cor_ml} decomposes correlations from multilevel data into within-group
and between-group correlations. The workhorse of the function is
\code{\link[psych]{statsBy}}.
}
\examples{

# traditional use
tmp <- c("outcome","case","session","trt_time") # roxygen2 does not like c() inside []
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp]
stats_by <- psych::statsBy(dat, group = "case") # requires you to include "case" column in dat
cor_ml(data = dat, vrb.nm = c("outcome","session","trt_time"), grp.nm = "case")

# varying the \code{use} and \code{method} arguments
cor_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "pairwise", method = "pearson")
cor_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "complete", method = "kendall")
cor_ml(data = airquality, vrb.nm = c("Ozone","Solar.R","Wind","Temp"), grp.nm = "Month",
   use = "everything", method = "spearman")

}
\seealso{
\code{\link{corp_ml}} for multilevel correlations with significance symbols,
   \code{\link{cor_by}} for correlation matrices by group,
   \code{\link[stats]{cor}} for traditional, single-level correlation matrices,
   \code{\link[psych]{statsBy}} the workhorse for the \code{cor_ml} function,
}
