% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{colMeans_if}
\alias{colMeans_if}
\title{Column Means Conditional on Frequency of Observed Values}
\usage{
colMeans_if(x, ov.min = 1, prop = TRUE, inclusive = TRUE)
}
\arguments{
\item{x}{numeric or logical matrix. If not a matrix, it will be coerced to
one.}

\item{ov.min}{minimum frequency of observed values required per column. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{nrow(x)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the mean
should be calculated if the frequency of observed values in a column is
exactly equal to \code{ov.min}.}
}
\value{
numeric vector of length = \code{ncol(x)} with names =
  \code{colnames(x)} providing the mean of each column or NA depending on the
  frequency of observed values.
}
\description{
\code{colMeans_if} calculates the mean of every column in a numeric or
logical matrix conditional on the frequency of observed data. If the
frequency of observed values in that column is less than (or equal to) that
specified by \code{ov.min}, then NA is returned for that row.
}
\details{
Conceptually this function does: \code{apply(X = x, MARGIN = 2, FUN =
mean_if, ov.min = ov.min, prop = prop, inclusive = inclusive)}. But for
computational efficiency purposes it does not because then the missing values
conditioning would not be vectorized. Instead, it uses \code{colMeans} and
then inserts NAs for columns that have too few observed values.
}
\examples{
colMeans_if(airquality)
colMeans_if(x = airquality, ov.min = 150, prop = FALSE)
}
\seealso{
\code{\link{colSums_if}}
   \code{\link{rowMeans_if}}
   \code{\link{rowSums_if}}
   \code{\link{colMeans}}
}
