% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mia_functions.R
\name{amd_multi}
\alias{amd_multi}
\title{Amount of Missing Data - Multivariate (Listwise Deletion)}
\usage{
amd_multi(data, vrb.nm, prop = TRUE, ov = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of the colnames from \code{data} specifying
the variables.}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
numeric vector of length 1 providing the frequency of missing (or
  observed if \code{ov} = TRUE) rows from listwise deletion for the set of
  variables \code{vrb.nm}. If \code{prop} = TRUE, the value will range from 0
  to 1. If \code{prop} = FALSE, the value will range from 0 to
  \code{nrow(data)}.
}
\description{
\code{amd_multi} by default computes the proportion of missing data from
listwise deletion for a set of variables in a data.frame, with arguments to
allow for counts instead of proportions (i.e., \code{prop}) or observed data
rather than missing data (i.e., \code{ov}). It is multivariate in that the
variables are treated together as a set.
}
\examples{

amd_multi(airquality, vrb.nm = names(airquality)) # proportion of missing data
amd_multi(airquality, vrb.nm = names(airquality),
   ov = TRUE) # proportion of observed data
amd_multi(airquality, vrb.nm = names(airquality),
   prop = FALSE) # count of missing data
amd_multi(airquality, vrb.nm = names(airquality),
   prop = FALSE, ov = TRUE) # count of observed data

}
\seealso{
\code{\link{amd_uni}}
   \code{\link{amd_bi}}
}
