% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferences.R
\name{pref_type}
\alias{pref_type}
\title{pref_type}
\usage{
pref_type(x, n_items = NULL)
}
\arguments{
\item{x}{A \code{preferences} object (or vector data representing preferences)}

\item{n_items}{The number of items, needed to assess whether a selection is
complete or not. Defaults to \code{nlevels(x)} if \code{x} has class \code{preferences},
otherwise defaults to the length of the longest preference.}
}
\value{
One of \code{c("soc", "soi", "toc", "toi")}, indicating the type of
preferences in \code{x} (with or without ties / complete or incomplete rankings).
}
\description{
Ordinal preferences can order every item, or they can order a subset. Some
ordinal preference datasets will contain ties between items at a given rank.
Hence, there are four distinct types of preferential data:
\describe{
\item{\code{soc}}{Strict Orders - Complete List}
\item{\code{soi}}{Strict Orders - Incomplete List}
\item{\code{toc}}{Orders with Ties - Complete List}
\item{\code{toi}}{Orders with Ties - Incomplete List}
}
}
