#' @title
#' Checking binary relation symmetry.
#'
#' @description
#' Checks whether the input binary relation is symmetric.
#'
#' @param rel A two-columns character matrix, each row comprising an element (pair) of the binary relation.
#'
#' @return
#' A boolean value.
#'
#' @examples
#' rel <- matrix(c(
#'   "a", "b",
#'   "c", "b",
#'   "b", "d",
#'   "b", "a",
#'   "b", "c",
#'   "d", "b"
#' ), ncol = 2, byrow = TRUE)
#'
#' chk<-isSymmetric(rel)
#'
#' @name IsSymmetric
#' @export IsSymmetric
IsSymmetric <- function(rel) {
  if (ncol(rel) != 2)
    stop("rel must be two columns character matrix")
  if ((ncol(rel) * nrow(rel) > 0  && !is.character(rel)))
    stop("rel must be two columns character matrix")

  tryCatch({
    result <- .Call("_isSymmetric", rel)
    return (result)
  }, error = function(err) {
    err_split <- strsplit(err[[1]], split = ":")
    stop(err_split[[1]][length(err_split[[1]])])
  }) # END tryCatch
}
