% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_functions.R
\name{scale_color_poison}
\alias{scale_color_poison}
\alias{scale_colour_poison}
\alias{scale_fill_poison}
\title{Poison frog color scales for ggplot2}
\usage{
scale_color_poison(
  name,
  type = c("discrete", "continuous"),
  direction = 1,
  alpha = NULL,
  ...
)

scale_colour_poison(
  name,
  type = c("discrete", "continuous"),
  direction = 1,
  alpha = NULL,
  ...
)

scale_fill_poison(
  name,
  type = c("discrete", "continuous"),
  direction = 1,
  alpha = NULL,
  ...
)
}
\arguments{
\item{name}{Character. Name of the poison frog palette to use
one of \code{poison_palette_names()}.}

\item{type}{Either \code{"discrete"} or \code{"continuous"}. Selects which kind of
ggplot2 scale is constructed.}

\item{direction}{Integer. \code{1} for the palette in its stored order, \code{-1} to
reverse it.}

\item{alpha}{Optional numeric in \verb{[0, 1]}. Applies a uniform
transparency to all colors (both discrete and continuous modes).}

\item{...}{Additional arguments passed to the underlying ggplot2 scale.}
}
\value{
A ggplot2 scale object.
}
\description{
The \code{poison} scales provide color maps inspired by the diverse colors
of Neotropical poison frogs. For \strong{discrete} data it uses
\code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}, and for \strong{continuous} data it builds a smooth
gradient with \code{\link[ggplot2:scale_gradient]{ggplot2::scale_color_gradientn()}}.
}
\details{
\itemize{
\item \strong{Discrete:} relies on an internal function factory \code{poison_pal()} that
returns \code{n} colors (max. n = 5) on demand for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.
\item \strong{Continuous:} generates a 256-color gradient via \code{poison_palette()}
(type \code{"continuous"}) and passes it to \code{\link[ggplot2:scale_gradient]{ggplot2::scale_color_gradientn()}}.
}
}
\examples{
require(ggplot2)
require(gapminder)
require(ggridges)
require(tibble)
require(scales)


# Using `scale_color_poison()` with discrete scale
ggplot(gapminder, aes(x = lifeExp, y = log(gdpPercap), colour = continent)) +
 geom_point(alpha = 0.2) +
 scale_color_poison(name = "Ramazonica", type = "discrete") +
 stat_smooth() +
 facet_wrap(. ~ continent, scales = "free") +
 theme_minimal(21, base_line_size = 0.2) +
 theme(
   legend.position = "none",
   strip.background = element_blank(),
   strip.placement = "outside"
   )

# Using `scale_color_poison()` with continuous scale
ggplot(mtcars, aes(wt, mpg, colour = disp)) +
 geom_point(size = 3) +
 scale_color_poison("Ramazonica", type = "continuous", direction = -1) +
 stat_smooth(col = "black") +
 theme_classic(base_size = 32, base_line_size = 0.5)

# Using `scale_fill_poison()` with discrete scale
ggplot(gapminder, aes(x = continent, y = lifeExp, fill = continent)) +
geom_violin(trim = FALSE, alpha = 0.75) +
geom_jitter(
 shape = 21,
 position = position_jitter(0.1),
 alpha = 0.3,
 size = 0.8,
 bg = "grey"
 ) +
stat_summary(
 fun = mean,
 geom = "point",
 size = 1.5,
 color = "black",
 alpha = 0.6
 ) +
theme_classic(base_size = 32, base_line_size = 0.5) +
scale_fill_poison(
 name = "Ramazonica",
 type = "discrete",
 alpha = 0.95,
 direction = -1
 ) +
theme(legend.position = "none") +
xlab(NULL)


df_nottem <- tibble(year  = floor(time(nottem)),
                    month = factor(month.abb[cycle(nottem)],
                    levels = month.abb),
                    temp  = as.numeric(nottem))

# Using `scale_fill_poison()` with continuous scale
ggplot(df_nottem, aes(x = temp, y = month, fill = stat(x))) +
geom_density_ridges_gradient(scale = 2, rel_min_height = 0.01) +
scale_fill_poison(
 name = "Ramazonica",
 type = "continuous",
 alpha = 0.95,
 direction = 1
 ) +
labs(
fill = "ºF") +
theme_light(base_size = 26, base_line_size = 0.5) +
theme(
 legend.position = "right",
 legend.justification = "left",
 legend.margin = margin(0,0,0,0),
 legend.box.margin = margin(-20,-20,-20,-20)
 )

}
\seealso{
\code{poison_palette()}, \code{poison_pal()}
}
