% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{async_evaluators}
\alias{async_evaluators}
\alias{mirai_async}
\title{Async evaluators provided by plumber}
\usage{
mirai_async(...)
}
\arguments{
\item{...}{Further argument passed on to the internal async function.
See Details for information on which function handles the formatting
internally in each async evaluator}
}
\value{
A function taking \code{expr} and \code{envir}. The former is the expression to
evaluate and the latter is an environment with additional variables that
should be made available during evaluation
}
\description{
These functions support async request handling. You can register your own as
well using \code{\link[=register_async]{register_async()}}.
}
\section{Provided evaluators}{
\itemize{
\item \code{mirai_async()} uses \code{\link[mirai:mirai]{mirai::mirai()}}. It is registered as
\code{"mirai"}. Be aware that for this evaluator to be performant you should
start up multiple persistent background processes. See \code{\link[mirai:daemons]{mirai::daemons()}}.
}
}

\examples{
# Use the default mirai backend by setting `async = TRUE` with a handler

pa <- api() |>
  api_get("/hello/<name:string>", function(name) {
    list(
      msg = paste0("Hello ", name, "!")
    )
  }, async = TRUE)


}
