#' @title Cancer infiltration rates
#' 
#' @description This dataset features cancer infiltration rates and microsatellites data.
#' 
#' @name TxTum
#' @docType data
#' @format A data frame with 106 rows and 60 variables.
#' \describe{ 
#' \item{\code{CELTUMCO}}{a numeric vector}
#' \item{\code{age}}{a numeric vector}
#' \item{\code{sexe}}{a numeric vector}
#' \item{\code{HISTOADK}}{a numeric vector}
#' \item{\code{H2}}{a numeric vector}
#' \item{\code{P3}}{a numeric vector}
#' \item{\code{P4}}{a numeric vector}
#' \item{\code{E1}}{a numeric vector}
#' \item{\code{P5}}{a numeric vector}
#' \item{\code{R10}}{a numeric vector}
#' \item{\code{C3M}}{a numeric vector}
#' \item{\code{P6}}{a numeric vector}
#' \item{\code{RB}}{a numeric vector}
#' \item{\code{FL7A}}{a numeric vector}
#' \item{\code{P53}}{a numeric vector}
#' \item{\code{W2}}{a numeric vector}
#' \item{\code{P2}}{a numeric vector}
#' \item{\code{P1}}{a numeric vector}
#' \item{\code{W4}}{a numeric vector}
#' \item{\code{MT1}}{a numeric vector}
#' \item{\code{MT2}}{a numeric vector}
#' \item{\code{MT4}}{a numeric vector}
#' \item{\code{MT3}}{a numeric vector}
#' \item{\code{HLA}}{a numeric vector}
#' \item{\code{HLD}}{a numeric vector}
#' \item{\code{HLC}}{a numeric vector}
#' \item{\code{HLB}}{a numeric vector}
#' \item{\code{EA1}}{a numeric vector}
#' \item{\code{EA3}}{a numeric vector}
#' \item{\code{EA2}}{a numeric vector}
#' \item{\code{EA4}}{a numeric vector}
#' \item{\code{EB1}}{a numeric vector}
#' \item{\code{EB2}}{a numeric vector}
#' \item{\code{EB3}}{a numeric vector}
#' \item{\code{EB4}}{a numeric vector}
#' \item{\code{EGF1}}{a numeric vector}
#' \item{\code{EGF2}}{a numeric vector}
#' \item{\code{EGF3}}{a numeric vector}
#' \item{\code{EGF4}}{a numeric vector}
#' \item{\code{EGF5}}{a numeric vector}
#' \item{\code{EGF6}}{a numeric vector}
#' \item{\code{FL7B}}{a numeric vector}
#' \item{\code{VSFGF7}}{a numeric vector}
#' \item{\code{F3A}}{a numeric vector}
#' \item{\code{F3B}}{a numeric vector}
#' \item{\code{VSFGFR3}}{a numeric vector}
#' \item{\code{F4}}{a numeric vector}
#' \item{\code{Q5}}{a numeric vector}
#' \item{\code{VSTOP1}}{a numeric vector}
#' \item{\code{VSTOP2A}}{a numeric vector}
#' \item{\code{VSEGFR}}{a numeric vector}
#' \item{\code{AFRAEGFR}}{a numeric vector}
#' \item{\code{SRXRA}}{a numeric vector}
#' \item{\code{SMT}}{a numeric vector}
#' \item{\code{QMTAMPN}}{a numeric vector}
#' \item{\code{QMTDELN}}{a numeric vector}
#' \item{\code{SHL}}{a numeric vector}
#' \item{\code{SEA}}{a numeric vector}
#' \item{\code{SEB}}{a numeric vector}
#' \item{\code{QPCRFGF7}}{a numeric vector}
#' }
#' 
#' @references Régression Bêta PLS. (French) [PLS Beta regression.], 
#' F. Bertrand, N. Meyer, M. Beau-Faller, K. El Bayed, N. Izzie-J., 
#' M. Maumy-Bertrand, (2013), J. SFdS, 154(3):143-159 \cr
#' 
#' Partial Least Squares Regression for Beta Regression Models. 
#' F. Bertrand, M. Maumy (2021). useR! 2021, Zurich.\cr 
#' 
#' @keywords datasets
#' @examples
#' 
#' data
#' print(TxTum)
#' summary(TxTum)
#' 
"TxTum"
