test_that("Red waveband is correct for default", {
  expect_equal(Red(), Red("ISO"))
})

test_that("Red waveband is correct for \"ISO\"", {
  wb <- Red(std = "ISO")
  expect_equal(wl_range(wb), c(610, 760))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.ISO")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Red waveband is correct for \"Smith\"", {
  expect_message(Red("Smith"))
  expect_equal(Red("Smith"), Red("Smith10"))
})

test_that("wl range is correct for \"Smith10\"", {
  wb <- Red(std = "Smith10")
  expect_equal(wl_range(wb), c(655, 665))
  expect_equal(labels(wb)$label, "R")
  expect_equal(labels(wb)$name, "Red.Smith10")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Smith20\"", {
  wb <- Red(std = "Smith20")
  expect_equal(wl_range(wb), c(650, 670))
  expect_equal(labels(wb)$label, "R")
  expect_equal(labels(wb)$name, "Red.Smith20")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Red waveband is correct for \"Apogee\"", {
  wb <- Red("Apogee")
  expect_equal(wl_range(wb), c(645, 665))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.Apogee")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Inada\"", {
  wb <- Red(std = "Inada")
  expect_equal(wl_range(wb), c(600, 700))
  expect_equal(labels(wb)$label, "R")
  expect_equal(labels(wb)$name, "Red.Inada")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  wb <- Red(std = "broad")
  expect_equal(wl_range(wb), c(600, 700))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.broad")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  expect_equal(Red("Broad"), Red("broad"))
})

test_that("wl range is correct for \"Warrington\"", {
  wb <- Red(std = "Warrington")
  expect_equal(wl_range(wb), c(625, 675))
  expect_equal(labels(wb)$label, "R")
  expect_equal(labels(wb)$name, "Red.Warrington")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Sellaro\"", {
  wb <- Red(std = "Sellaro")
  expect_equal(wl_range(wb), c(620, 680))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.Sellaro")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"RS\"", {
  wb <- Red(std = "RS")
  expect_equal(wl_range(wb), c(630, 680))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.RS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatOLI\"", {
  wb <- Red(std = "LandsatOLI")
  expect_equal(wl_range(wb), c(630, 680))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.LandsatOLI")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatMSS\"", {
  wb <- Red(std = "LandsatMSS")
  expect_equal(wl_range(wb), c(600, 700))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.LandsatMSS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatTM\"", {
  wb <- Red(std = "LandsatTM")
  expect_equal(wl_range(wb), c(630, 690))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.LandsatTM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatETM\"", {
  wb <- Red(std = "LandsatETM")
  expect_equal(wl_range(wb), c(630, 690))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.LandsatETM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatRBV\"", {
  wb <- Red(std = "LandsatRBV")
  expect_equal(wl_range(wb), c(580, 680))
  expect_equal(labels(wb)$label, "Red")
  expect_equal(labels(wb)$name, "Red.LandsatRBV")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Red waveband is correct for bad std", {
  expect_warning(wb <- Red(std = "bad-std"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})
