test_that("blue waveband is correct for default", {
  expect_equal(Blue(), Blue("ISO"))
})

test_that("blue waveband is correct for \"ISO\"", {
  wb <- Blue(std = "ISO")
  expect_equal(wl_range(wb), c(450, 500))
  expect_equal(wl_range(wb), range(Blue()))
  expect_equal(wl_range(wb), range(Blue("ISO")))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.ISO")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Sellaro\"", {
  wb <- Blue(std = "Sellaro")
  expect_equal(wl_range(wb), c(420, 490))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.Sellaro")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  wb <- Blue(std = "broad")
  expect_equal(wl_range(wb), c(400, 500))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.broad")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"RS\"", {
  wb <- Blue(std = "RS")
  expect_equal(wl_range(wb), c(450, 515))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.RS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatTM\"", {
  wb <- Blue(std = "LandsatTM")
  expect_equal(wl_range(wb), c(450, 520))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.LandsatTM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatETM\"", {
  wb <- Blue(std = "LandsatETM")
  expect_equal(wl_range(wb), c(450, 520))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.LandsatETM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatOLI\"", {
  wb <- Blue(std = "LandsatOLI")
  expect_equal(wl_range(wb), c(450, 515))
  expect_equal(labels(wb)$label, "Blue")
  expect_equal(labels(wb)$name, "Blue.LandsatOLI")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Blue waveband is correct for bad std", {
  expect_warning(wb <- Blue(std = "bad-std"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})
