% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie.r
\name{erythema}
\alias{erythema}
\alias{CIE}
\title{Constructor of erythema-weighted waveband}
\usage{
erythema(std = "CIE98", norm = 298, w.low = 250, w.high = 400)

CIE(norm = 298, w.low = 250, w.high = 400)
}
\arguments{
\item{std}{a character string, currently only "CIE98" supported.}

\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting
  function and normalization wavelength.
}
\description{
Erythema BSWF (1998 update)
}
\note{
The erythema BSWF from CIE is specified by a mathematical formula, and
this is used directly in the definition of the returned waveband.

Standard DIN 5031-10:2018-03 defines BSWF \emph{er} as a table of
interpolated values derived from CIE's definition from 1998. So, the values
computed using this R package do not necessarily exactly match those
according to DIN 5031-10:2018-03. The range of wavelengths used, 250 to 400
nm, does agree, with those in the standard.
}
\examples{
erythema()
erythema("CIE98")
CIE()
CIE(norm = 300)
erythema(norm = 300)

}
\references{
Webb, A. R.; Slaper, H.; Koepke, P. & Schmalwieser, A. W. (2011) Know your
standard: clarifying the CIE erythema action spectrum. Photochemistry and
photobiology, 2011, 87, 483-486

DIN (2018) Standard DIN 5031-10:2018-03 Optical radiation physics and
illuminating engineering. Part 10: Photobiologically effective radiation,
quantities, symbols and action spectra. Beuth Verlag, Berlin 2018.
}
\seealso{
\code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: 
\code{\link{CH4}()},
\code{\link{DNA_GM}()},
\code{\link{DNA_N}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_M}()},
\code{\link{GEN_T}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()}

Other BSWF weighted wavebands: 
\code{\link{CH4}()},
\code{\link{DNA_GM}()},
\code{\link{DNA_N}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_M}()},
\code{\link{GEN_T}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()}
}
\concept{BSWF weighted wavebands}
