% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.m.r
\name{GEN_M}
\alias{GEN_M}
\title{Constructor of GPAS (Micheletti's formulation) weighted waveband}
\usage{
GEN_M(norm = 300, w.low = 275, w.high = 313.3)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting function
and normalization wavelength.
}
\description{
Generalized Plant Action BSWF of Caldwell [1] as formulated by Micheletti et
al. [2]
}
\note{
In the original publication [2] describing the formulation, the
  long-end wavelength boundary is specified as 313.3 nm. This is the default
  used here. However, in some cases it is of interest to vary this limit in
  sensitivity analyses. The effect on the RAF and doses of changing this
  boundary is substantial, and has been analysed by Micheletti et al. [3].
}
\examples{
GEN_M()
GEN_M(300)

}
\references{
[1]Caldwell, M. M. (1971) Solar UV irradiation and the growth and development
of higher plants. In Giese, A. C. (Ed.) Photophysiology, Academic Press,
1971, 6, 131-177

[2] Micheletti, M. I.; Piacentini, R. D. & Madronich, S. (2003) Sensitivity
of Biologically Active UV Radiation to Stratospheric Ozone Changes: Effects
of Action Spectrum Shape and Wavelength Range Photochemistry and
Photobiology, 78, 456-461
}
\seealso{
\code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: 
\code{\link{CH4}()},
\code{\link{DNA_GM}()},
\code{\link{DNA_N}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_T}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()},
\code{\link{erythema}()}
}
\concept{BSWF weighted wavebands}
