% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_performance.R
\name{pq_performance}
\alias{pq_performance}
\title{calculating performance metrics}
\usage{
pq_performance(dt, Ra, Rb = NULL, perf_fun, ...)
}
\arguments{
\item{dt}{a list/dataframe of time series datasets.}

\item{Ra}{the column name of asset returns.}

\item{Rb}{the column name of baseline returns, defaults to NULL.}

\item{perf_fun}{performance function from \code{PerformanceAnalytics} package, see \code{pq_perf_funs}.}

\item{...}{additional parameters, the arguments used in \code{PerformanceAnalytics} functions.}
}
\description{
\code{pq_performance} calculates performance metrics based on returns of market price or portfolio. The performance analysis functions are calling from \code{PerformanceAnalytics} package, which includes many widely used performance metrics.
}
\examples{
 
\dontrun{
library(pedquant) 
library(data.table)

# load data
data(dt_banks)
data(dt_ssec)

# calculate returns
datret1 = pq_return(dt_banks, 'close', freq = 'monthly', rcol_name = 'Ra')
datret2 = pq_return(dt_ssec, 'close', freq = 'monthly', rcol_name = 'Rb')

# merge returns of assets and baseline
datRaRb = merge(
    rbindlist(datret1)[, .(date, symbol, Ra)], 
    rbindlist(datret2)[, .(date, Rb)],
    by = 'date', all.x = TRUE
)

# claculate table.CAPM metrics
perf_capm = pq_performance(datRaRb, Ra = 'Ra', Rb = 'Rb', perf_fun = 'table.CAPM')
rbindlist(perf_capm, idcol = 'symbol')
}

}
