% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_law.R
\name{fit_variance_law}
\alias{fit_variance_law}
\title{Fit Fairfield-Smith's variance law to matrix data with ggplot2 plots}
\usage{
fit_variance_law(df_mat, plot_curve = TRUE)
}
\arguments{
\item{df_mat}{numeric matrix of data}

\item{plot_curve}{logical, if TRUE returns ggplot objects}
}
\value{
list with results:
\itemize{
\item df_shapes: data.frame of plot shapes
\item V1: variance at 1x1
\item b_hat: estimated variance law coefficient
\item R2_log: weighted R^2 on log-log scale
\item x_opt: optimum plot size (units)
\item Vx_opt: predicted variance at optimum
\item best_shape: recommended shape for optimum plot size
\item plots: list of ggplot objects if plot_curve = TRUE
}
}
\description{
This function fits the Fairfield-Smith variance law, computes weighted R^2 on
the log-log scale, identifies the optimum plot size and recommended shape,
and produces two ggplot2 visualisations (original and log scale).
}
