% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openssh.R
\name{fingerprint}
\alias{fingerprint}
\title{OpenSSH fingerprint}
\usage{
fingerprint(key, hashfun = sha256)
}
\arguments{
\item{key}{a public or private key}

\item{hashfun}{which hash function to use to calculate the fingerprint}
}
\description{
Calculates the OpenSSH fingerprint of a public key. This value should
match what you get to see when connecting with SSH to a server. Note
that some other systems might use a different algorithm to derive a
(different) fingerprint for the same keypair.
}
\examples{
mykey <- rsa_keygen()
pubkey <- as.list(mykey)$pubkey
fingerprint(mykey)
fingerprint(pubkey)

# Some systems use other hash functions
fingerprint(pubkey, sha1)
fingerprint(pubkey, sha256)

# Other key types
fingerprint(dsa_keygen())
}
