% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_nnaive.R
\name{auto_nnaive}
\alias{auto_nnaive}
\title{Fitting a NNaive Model}
\usage{
auto_nnaive(
  y,
  er,
  xreg = NULL,
  p,
  q,
  P = 1,
  size,
  skip,
  repeats = 1000,
  lambda = 0.5,
  lambdae = 0.5,
  scale.inputs = TRUE,
  ...
)
}
\arguments{
\item{y}{A numeric vector or time series of class \code{ts}.}

\item{er}{A numeric vector or time series object representing the series of residuals. If missing, it will be calculated from a Naive model.}

\item{xreg}{An optional numeric matrix of exogenous variables to be included in the model (default is \code{NULL}).}

\item{p}{Integer indicating the number of lags of the input series \code{y}.}

\item{q}{Integer indicating the number of lags of the errors \code{er}.}

\item{P}{Integer indicating the number of seasonal lags of the input series \code{y} (default is \code{1}).}

\item{size}{Integer specifying the number of nodes of the feed-forward neural networks with a single hidden layer.}

\item{skip}{Logical value indicating whether to use the direct connections in the neural network (default is \code{TRUE}).}

\item{repeats}{Integer specifying the number of times to fit the neural network model (default is \code{1000}).}

\item{lambda}{Numeric value for the Box-Cox transformation parameter of \code{y} (default is \code{0.5}).}

\item{lambdae}{Numeric value for the Box-Cox transformation parameter of \code{er} (default is \code{0.5}).}

\item{scale.inputs}{Logical value indicating whether to standardize the inputs before fitting the model (default is \code{TRUE}).}

\item{...}{Additional arguments passed to \code{auto_nnaive}.}
}
\value{
Returns an object of class "narfima" with the same structure as \code{narfima},
but using Naive residuals instead of ARFIMA residuals.
}
\description{
This function fits Neural Naive (NNaive) model to a univariate time series. It follows the same framework as \code{narfima}, but replaces
the ARFIMA component with a Naive model. This function is intended for ablation studies to benchmark the performance of
\code{narfima} against alternatives.
}
