% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_bsts.R
\name{auto_nbsts}
\alias{auto_nbsts}
\title{Fitting a NBSTS Model}
\usage{
auto_nbsts(
  y,
  er,
  ss,
  xreg = NULL,
  p,
  q,
  P = 1,
  size,
  skip,
  niter = 1000,
  repeats = 1000,
  lambda = 0.5,
  lambdae = 0.5,
  scale.inputs = TRUE,
  ...
)
}
\arguments{
\item{y}{A numeric vector or time series of class \code{ts}.}

\item{er}{A numeric vector or time series object representing the series of residuals. If missing, it will be calculated from a BSTS model.}

\item{ss}{A BSTS state specification list. By default, a \code{semilocal linear trend} and \code{seasonal components} are added using \code{y}.}

\item{xreg}{An optional numeric matrix of exogenous variables to be included in the model (default is \code{NULL}).}

\item{p}{Integer indicating the number of lags of the input series \code{y}.}

\item{q}{Integer indicating the number of lags of the errors \code{er}.}

\item{P}{Integer indicating the number of seasonal lags of the input series \code{y} (default is \code{1}).}

\item{size}{Integer specifying the number of nodes of the feed-forward neural networks with a single hidden layer.}

\item{skip}{Logical value indicating whether to use the direct connections in the neural network (default is \code{TRUE}).}

\item{niter}{Integer specifying the number of MCMC iterations for fitting the BSTS model (default is \code{1000}).}

\item{repeats}{Integer specifying the number of times to fit the neural network model (default is \code{1000}).}

\item{lambda}{Numeric value for the Box-Cox transformation parameter of \code{y} (default is \code{0.5}).}

\item{lambdae}{Numeric value for the Box-Cox transformation parameter of \code{er} (default is \code{0.5}).}

\item{scale.inputs}{Logical value indicating whether to standardize the inputs before fitting the model (default is \code{TRUE}).}

\item{...}{Additional arguments passed to \code{auto_nbsts}.}
}
\value{
Returns an object of class "narfima" with the same structure as \code{narfima},
but using BSTS residuals instead of ARFIMA residuals.
}
\description{
This function fits Neural Bayesian Structural Time Series (NBSTS) model to a univariate time series. It follows the same
architecture as \code{narfima}, but replaces the ARFIMA component with a BSTS framework. By default, the state specification includes a
\code{semilocal linear trend} component and a \code{seasonal} component with \code{12} periods. The model is estimated using MCMC sampling with \code{1000}
iterations by default. This function is intended for ablation studies to benchmark the performance of
\code{narfima} against alternatives.
}
