% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcc.R
\name{qcc}
\alias{qcc}
\title{Quantile correlation coefficient}
\usage{
qcc(
  x,
  y,
  tau = c(0.1, 0.5, 0.9),
  data,
  method = "br",
  boot_n = NULL,
  ci_level = 0.95
)
}
\arguments{
\item{x}{Name of x variable. Character string.}

\item{y}{Name of y variable. Character string.}

\item{tau}{The quantile(s) to be estimated. A vector of values between 0 and 1, default c(.1,.5,.9). @seealso \code{\link[quantreg]{rq}}}

\item{data}{Data frame.}

\item{method}{The algorithmic method used to compute the fit (default "br"). @seealso \code{\link[quantreg]{rq}}}

\item{boot_n}{Number of bootstrap redraws (default NULL = no bootstrap inference).}

\item{ci_level}{Level for percentile bootstrap confidence interval. Numeric values between 0 and 1. Default .95.}
}
\value{
\item{r}{Pearson's correlation estimate for comparison.}
\item{rho_tau}{Correlations at different tau values (quantiles).}
\item{r_boot_est}{Pearson's correlation bootstrap estimates.}
\item{rho_tau_boot_est}{Bootstrap estimates for correlations at different tau values (quantiles).}
}
\description{
For computation of tail dependence as correlations estimated at different variable quantiles (Choi & Shin, 2022; Lee et al., 2022) summarized across two quantile regression models where x and y switch roles as independent/dependent variables.
}
\details{
Note that when quantile regression coefficients for y on x and x on y have a different sign, the quantile correlation is defined as zero (see Choi & Shin, 2022, p. 1080).
}
\examples{
set.seed(2321)
d <- data.frame(x = rnorm(2000))
d$y <- 0.10 * d$x + (0.20) * d$x^2 + 0.40 * d$x^3 + (-0.20) * d$x^4 + rnorm(2000)
qcc_boot <- qcc(x = "x", y = "y", data = d, tau = 1:9 / 10, boot_n = 50)
qcc_boot$rho_tau
}
\references{
Choi, J.-E., & Shin, D. W. (2022). Quantile correlation coefficient: A new tail dependence measure. Statistical Papers, 63(4), 1075–1104. https://doi.org/10.1007/s00362-021-01268-7

Lee, J. A., Bardi, A., Gerrans, P., Sneddon, J., van Herk, H., Evers, U., & Schwartz, S. (2022). Are value–behavior relations stronger than previously thought? It depends on value importance. European Journal of Personality, 36(2), 133–148. https://doi.org/10.1177/08902070211002965
}
