% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-runs.R
\name{mlflow_search_runs}
\alias{mlflow_search_runs}
\title{Search Runs}
\usage{
mlflow_search_runs(
  filter = NULL,
  run_view_type = c("ACTIVE_ONLY", "DELETED_ONLY", "ALL"),
  experiment_ids = NULL,
  order_by = list(),
  client = NULL
)
}
\arguments{
\item{filter}{A filter expression over params, metrics, and tags, allowing returning a subset
of runs. The syntax is a subset of SQL which allows only ANDing together binary operations
between a param/metric/tag and a constant.}

\item{run_view_type}{Run view type.}

\item{experiment_ids}{List of string experiment IDs (or a single string experiment ID) to search
over. Attempts to use active experiment if not specified.}

\item{order_by}{List of properties to order by. Example: "metrics.acc DESC".}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Search for runs that satisfy expressions. Search expressions can use Metric and Param keys.
}
