% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.R
\name{levene}
\alias{levene}
\alias{row_levene}
\alias{col_levene}
\alias{row_brownforsythe}
\alias{col_brownforsythe}
\title{Levene test}
\usage{
row_levene(x, g)

col_levene(x, g)

row_brownforsythe(x, g)

col_brownforsythe(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of the Levene's test
performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
3. df.between - between group (treatment) degrees of freedom\cr
4. df.within - within group (residual) degrees of freedom\cr
5. statistic - F statistic\cr
6. pvalue - p.value
}
\description{
Levene's test and Brown-Forsythe test for equality of variances
between groups on each row/column of the input matrix.
}
\details{
NA values are always ommited.
If values are missing for a whole group - that group is discarded.

\code{row_levene(x, g)} - Levene's test on rows.
\code{col_levene(x, g)} - Levene's test on columns.

\code{row_brownforsythe(x, g)} - Brown-Forsythe test on rows.
\code{col_brownforsythe(x, g)} - Brown-Forsythe test on columns.
}
\note{
Difference between Levene's test and Brown-Forsythe test is that
the Brown-Forsythe test uses the median instead of the mean in computing the
spread within each group. Many software implementations use the name
"Levene's test" for both variants.
}
\examples{
col_levene(iris[,1:4], iris$Species)
row_brownforsythe(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{\link[car]{leveneTest}}
}
\author{
Karolis Koncevičius
}
