% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyCreateTableOneJS.R
\name{ChangeSvyTable}
\alias{ChangeSvyTable}
\title{ChangeSvyTable: Modify the number n}
\usage{
ChangeSvyTable(svy, ori)
}
\arguments{
\item{svy}{TableOne object that take weights into account}

\item{ori}{TableOne object in the original data}
}
\value{
A matrix that replaces the n number of weights with the n number of the original data
}
\description{
Replace the number of weights taken into account with the number of n in the original data
}
\details{
DETAILS
}
\examples{
# example code
library('survey'); library('tableone')
data(nhanes)
nhanes$SDMVPSU <- as.factor(nhanes$SDMVPSU)
nhanesSvy <- svydesign(
  ids = ~SDMVPSU, strata = ~SDMVSTRA, weights = ~WTMEC2YR,
  nest = TRUE, data = nhanes
)

res <- svyCreateTableOne(
  vars = c("HI_CHOL", "race", "agecat", "RIAGENDR"),
  strata = "RIAGENDR", data = nhanesSvy,
  factorVars = c("HI_CHOL", "race", "RIAGENDR")
)

ori <- CreateTableOne(
  vars = c("HI_CHOL", "race", "agecat", "RIAGENDR"),
  strata = "RIAGENDR", data = nhanes,
  factorVars = c("HI_CHOL", "race", "RIAGENDR")
)
ChangeSvyTable(res, ori)
}
