% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sp500}
\alias{sp500}
\title{Daily S&P 500 Index data from 1950 to 2015}
\format{
A tibble with 16,607 rows and 7 variables:
\describe{
\item{date}{The date expressed as \code{Date} values.}
\item{open, high, low, close}{The day's opening, high, low, and closing
prices in USD. The \code{close} price is adjusted for splits.}
\item{volume}{The number of trades for the given \code{date}.}
\item{adj_close}{The close price adjusted for both dividends and splits.}
}
}
\usage{
sp500
}
\description{
This dataset provides daily price indicators for the S&P 500 index from the
beginning of 1950 to the end of 2015. The index includes 500 leading
companies and captures about 80 percent coverage of available market
capitalization.
}
\section{Dataset ID and Badge}{

DATA-4

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_sp500.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\examples{
dplyr::glimpse(sp500)
}
\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
