% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_footnotes}
\alias{cells_footnotes}
\title{Location helper for targeting the footnotes}
\usage{
cells_footnotes()
}
\value{
A list object with the classes \code{cells_footnotes} and
\code{location_cells}.
}
\description{
\code{cells_footnotes()} is used to target all footnotes in the
footer section of the table. This is useful for adding custom styles to the
footnotes with \code{\link[=tab_style]{tab_style()}} (using the \code{locations} argument). The
'footnotes' location is generated by one or more uses of \code{\link[=tab_footnote]{tab_footnote()}}.
This location helper function cannot be used for the \code{locations} argument of
\code{tab_footnote()} and doing so will result in a warning (with no change made
to the table).
}
\section{Examples}{


Using a subset of the \code{\link{sza}} dataset, let's create a \strong{gt} table. We'd like
to color the \code{sza} column so that's done with the \code{\link[=data_color]{data_color()}} function. We
can add a footnote with \code{\link[=tab_footnote]{tab_footnote()}} and we can also style the
footnotes section. The styling is done with \code{\link[=tab_style]{tab_style()}} and
\code{locations = cells_footnotes()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sza |>
  dplyr::filter(
    latitude == 20 &
      month == "jan" &
      !is.na(sza)
  ) |>
  dplyr::select(-latitude, -month) |>
  gt() |>
  data_color(
    columns = sza,
    palette = c("white", "yellow", "navyblue"),
    domain = c(0, 90)
  ) |>
  tab_footnote(
    footnote = "Color indicates height of sun.",
    locations = cells_column_labels(columns = sza)
  ) |>
  tab_options(table.width = px(320)) |>
  tab_style(
    style = list(
      cell_text(size = "smaller"),
      cell_fill(color = "gray90")
      ),
    locations = cells_footnotes()
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_footnotes_1.png" alt="This image of a table was generated from the first code example in the `cells_footnotes()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-23
}

\section{Function Introduced}{

\code{v0.3.0} (May 12, 2021)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
